/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/

var STBWidgetProgress = Object.create(STBModule.prototype);

STBWidgetProgress.name = "WidgetProgress";
STBWidgetProgress.initPlugin = function() {
    try {
        var progress = jQuery('.progress-item:not(.__done)');

        if (progress.length > 0) {

        	var ScrollMagicGlobalController = new ScrollMagic.Controller();

			progress.each(function(){
				var el = jQuery(this),
					scene = new ScrollMagic.Scene({                        
						triggerElement: this,
						triggerHook: 0.9,
						duration: "50%",
						reverse: false
					})
					.on("start leave", function(event) {

						el.find(".progress-status").animate(
							{
								width: el.attr("data-perc") + "%"
							},
							800
						);

					})
					.addTo(ScrollMagicGlobalController);

				el.addClass("__done");
			});

        }

    } catch (e) {
        getStack(0, e);
    }
}


STBWidgetProgress.runOnReady = function() {
	STBWidgetProgress.initPlugin();
}

STBWidgetProgress.runOnContentUpdate = function() {
	STBWidgetProgress.initPlugin();
}

site.registerModule(STBWidgetProgress);